define([
    'App',
    'marionette',
    'underscore',
    'modules/appointments/appointments-module',
    'text!modules/appointments/requested/requested-appointment-provider-preferences.html',
],
function (
    app,
    Marionette,
    _,
    module,
    template
) {
    'use strict';

    return Marionette.View.extend({
        template: template,
        initialize: function(options) {
            this.setDisplayString();
            this.sortProviders();
        },
        sortProviders: function() {
            if (this.model.get('preferredProviders')) {
                this.model.set('preferredProviders', this.model.get('preferredProviders').sort(function(lhs, rhs) {
                    return lhs.preferredOrder - rhs.preferredOrder;
                }));
            }
        },
        setDisplayString: function() {
            var providers = this.model.get('preferredProviders');
            _.each(providers, function(provider) {
                this.setAddressString(provider);
                this.setNameString(provider);
            }.bind(this));
        },
        setAddressString: function(provider) {
            provider.address.cityState = provider.address.city ? provider.address.city : provider.address.state;
            if (provider.address.city && provider.address.state) {
                provider.address.cityState += ' ' + provider.address.state;
            }
            provider.addressString = $.grep([
                _.escape(provider.address.street),
                _.escape(provider.address.cityState),
                _.escape(provider.address.zipCode),
            ], Boolean).join(', ');
        },
        setNameString: function(provider) {
            provider.name = provider.firstName ? provider.firstName : '';
            if (provider.firstName && provider.lastName) {
                provider.name += ' ';
            }
            provider.name += provider.lastName ? provider.lastName : '';

            provider.display = $.grep([
                _.escape(provider.name),
                _.escape(provider.practiceName),
                _.escape(provider.addressString),
            ], Boolean).join(',<br>');
        },
    });

});
